def parse(code):
    if any([c == ' ' for c in code]):
        return True
    pos = 0
    while len(code) > pos:
        done, pos_ = parse_html(code[pos:])
        if not done:
            return False
        pos += pos_
    return True

def parse_html(code):
    done = True
    state = 0 
    i = 0
    name = ''
    endname = ''
    while done:
        current = code[i]
        if state == 0:
            if current == "<":
                state = 1
            else:
                return False, -1
        elif state == 1:
            if name != '' and current == '>':
                if not name.isalpha():
                    return False, -1
                if any([c != c.lower() for c in code]):
                    return False, -1
                pos = code.find(f'</{name}>', i)
                if pos == -1:
                    return False, -1
                if i != pos - 1:
                    done = parse_html(code[i + 1:pos])
                    if not done:
                        return False, -1
                return True, pos + 3 + len(name)
            elif current == '>' or current == '<' or current == '/':
                return False, -1
            else:
                name += current
        

        i+=1
    return False, -1

print("YES" if parse(input()) else "NO")